/******************************************************************************
													Copyright (c) Freescale 2004
File Name    : $RCSfile: s12hy_vectors.c,v $

Engineer     : $Author: ttz890 $

Location     : EKB

Date Created : 16/10/07

Current Revision :	$Revision: 1.7 $

Notes            :  

*******************************************************************************
Freescale reserves the right to make changes without further notice to any
product herein to improve reliability, function or design. Freescale does
not assume any liability arising out ot the application or use of any
product, circuit, or software described herein; neither does it convey any
license under its patent rights nor the rights of others. Freescale products
are not designed, intended, or authorized for use as components in systems
intended for surgical implant into the body, or other applications intended
to support life, or for any other application in which the failure of the
Freescale product could create a situation where personal injury or death may
occur. Should Buyer purchase or use Freescale products for any such unintended
or unauthorized application, Buyer shall idemnify and hold Freescale and its
officers, employees, subsidiaries, affiliates, and distributors harmless
against all claims costs, damages, and expenses, and reasonable attorney fees
arising out of, directly or indirectly, any claim of personal injury or death
associated with such unintended or unathorized use, even if such claim alleges
that Freescale was negligent regarding the design or manufacture of the part.
Freescale and the Freescale logo* are registered trademarks of Freescale Ltd.
******************************************************************************/

/************************* Include Files *************************************/
#include <hidef.h>
#include <start12.h>
#include "target.h"
#include "S12HY_peripherals.h"
#include "S12HY_vectors.h"

/************************* typedefs ******************************************/
/* in s12hy_vectors.h */
/************************* function prototypes *******************************/
/* in s12hy_vectors.h */
#pragma CODE_SEG __NEAR_SEG NON_BANKED 

/************************* #defines ******************************************/
/* in s12x_vectors.h */
/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT
/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
/************************* Functions *****************************************/
//#pragma CODE_SEG __NEAR_SEG NON_BANKED 

#include <non_bank.sgm>
/******************************************************************************
Function Name  : Default_ISR
Engineer       : r27624	
Date           : 06/05/2003
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for unused interrupt vectors. 
******************************************************************************/
#pragma TRAP_PROC [SAVE_NO_REGS]
void 
Default_ISR(void)
{
   asm BGND;
}

/******************************************************************************
Function Name  : SpuriousISR
Engineer       : r27624	
Date           : 06/05/2003
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for spurious interrupt vector. 
******************************************************************************/
#pragma TRAP_PROC [SAVE_NO_REGS]
void 
SpuriousISR(void) 
{
   asm BGND;
}

#pragma CODE_SEG DEFAULT

#pragma CONST_SEG __NEAR_SEG S12HY_VECTOR_TABLE
/*****************************************************************************
ResetVectorTable
Interrupt vector table for S12HY64
This is the default CPU interrupt vector table at reset: IVBR = $FF
Other vector tables can be created and used by changing IVBR
*****************************************************************************/
/* vector table to be located at address 0xFF00 */
const void (*const near _vectab[])(void) = 
{                             
	(void*)0xFFFF,		/* 0xFF00 backdoor key               */
	(void*)0xFFFF,		/* 0xFF02                            */
	(void*)0xFFFF,		/* 0xFF04                            */
	(void*)0xFFFF,		/* 0xFF06                            */
	(void*)0xFFFF,		/* 0xFF08                            */
	(void*)0xFFFF,		/* 0xFF0A                            */ 
	(void*)0xFFFF,		/* 0xFF0C                            */ 
	(void*)0xFFFE,		/* 0xFF0E security                   */
    ReservedISR,                 /* 0xFF10 Reserved */
    ReservedISR,                 /* 0xFF12 Reserved */
    ReservedISR,                 /* 0xFF14 Reserved */
    ReservedISR,                 /* 0xFF16 Reserved */
    ReservedISR,                 /* 0xFF18 Reserved */
    ReservedISR,                 /* 0xFF1A Reserved */
    ReservedISR,                 /* 0xFF1C Reserved */
    ReservedISR,                 /* 0xFF1E Reserved */
    ReservedISR,                 /* 0xFF20 Reserved */
    ReservedISR,                 /* 0xFF22 Reserved */
    ReservedISR,                 /* 0xFF24 Reserved */
    ReservedISR,                 /* 0xFF26 Reserved */
    ReservedISR,                 /* 0xFF28 Reserved */
    ReservedISR,                 /* 0xFF2A Reserved */
    ReservedISR,                 /* 0xFF2C Reserved */
    ReservedISR,                 /* 0xFF2E Reserved */
    ReservedISR,                 /* 0xFF30 Reserved */
    ReservedISR,                 /* 0xFF32 Reserved */
    ReservedISR,                 /* 0xFF34 Reserved */
    ReservedISR,                 /* 0xFF36 Reserved */
    ReservedISR,                 /* 0xFF38 Reserved */
    ReservedISR,                 /* 0xFF3A Reserved */
    ReservedISR,                 /* 0xFF3C Reserved */                            
    ReservedISR,                 /* 0xFF3E Reserved */                            
    ReservedISR,                 /* 0xFF40 Reserved */     
    ReservedISR,                 /* 0xFF42 Reserved */     
    ReservedISR,                 /* 0xFF44 Reserved */  
    ReservedISR,                 /* 0xFF46 Reserved */                                 
    ReservedISR,                 /* 0xFF48 Reserved */ 
    ReservedISR,                 /* 0xFF4A Reserved */ 
    ReservedISR,                 /* 0xFF4C Reserved */ 
    ReservedISR,                 /* 0xFF4E Reserved */ 
    ReservedISR,                 /* 0xFF50 Reserved */ 
    ReservedISR,                 /* 0xFF52 Reserved */ 
    ReservedISR,                 /* 0xFF54 Reserved */ 
    ReservedISR,                 /* 0xFF56 Reserved */                     
    ReservedISR,                 /* 0xFF58 Reserved */          
    ReservedISR,                 /* 0xFF5A Reserved */          
    ReservedISR,                 /* 0xFF5C Reserved */          
    ReservedISR,                 /* 0xFF5E Reserved */          
    ReservedISR,                 /* 0xFF60 Reserved */
    ReservedISR,                 /* 0xFF62 Reserved */
    ReservedISR,                 /* 0xFF64 Reserved */
    ReservedISR,                 /* 0xFF66 Reserved */
    ReservedISR,                 /* 0xFF68 Reserved */
    ReservedISR,                 /* 0xFF6A Reserved */
    ReservedISR,                 /* 0xFF6C Reserved */
    ReservedISR,                 /* 0xFF6E Reserved */
    ReservedISR,                 /* 0xFF70 Reserved */
    ReservedISR,                 /* 0xFF72 Reserved */
    ReservedISR,                 /* 0xFF74 Reserved */
    ReservedISR,                 /* 0xFF76 Reserved */
    ReservedISR,                 /* 0xFF78 Reserved */
    ReservedISR,                 /* 0xFF7A Reserved */
    ReservedISR,                 /* 0xFF7C Reserved */
    ReservedISR,                 /* 0xFF7E Reserved */
    Default_ISR,                 /* 0xFF80 Spurious Interrupt */
    ReservedISR,                 /* 0xFF82 Reserved */
    Default_ISR,                 /* 0xFF84 ATD0 compare */                            
    Default_ISR,                 /* 0xFF86 High Temperature Interrupt */
    Default_ISR,                 /* 0xFF88 Autonomous periodical interrupt */
    Default_ISR,                 /* 0xFF8A Low-voltage interrupt */
    Default_ISR,                 /* 0xFF8C PWM Emergency Shutdown */
    Default_ISR,                 /* 0xFF8E Port T Interrupt */
    ReservedISR,                 /* 0xFF90 Reserved */
    ReservedISR,                 /* 0xFF92 Reserved */
    ReservedISR,                 /* 0xFF94 Reserved */
    Default_ISR,                 /* 0xFF96 Motor Control Timer Oveflow */
    ReservedISR,                 /* 0xFF98 Reserved */
    Default_ISR,                 /* 0xFF9A TIM 1 Pulse accumulator input edge */
    Default_ISR,                 /* 0xFF9C TIM 1 Pulse accumulator A overflow */
    Default_ISR,                 /* 0xFF9E TIM 1 Timer overflow */
    Default_ISR,                 /* 0xFFA0 TIM 1 Timer channel 7 */
    Default_ISR,                 /* 0xFFA2 TIM 1 Timer channel 6 */
    Default_ISR,                 /* 0xFFA4 TIM 1 Timer channel 5 */
    Default_ISR,                 /* 0xFFA6 TIM 1 Timer channel 4 */
    Default_ISR,                 /* 0xFFA8 TIM 1 Timer channel 3 */
    Default_ISR,                 /* 0xFFAA TIM 1 Timer channel 2 */
    Default_ISR,                 /* 0xFFAC TIM 1 Timer channel 1 */
    Default_ISR,                 /* 0xFFAE TIM 1 Timer channel 0 */
    Default_ISR,                 /* 0xFFB0 MSCAN 0 transmit */
    Default_ISR,                 /* 0xFFB2 MSCAN 0 receive */
    Default_ISR,                 /* 0xFFB4 MSCAN 0 errors */
    Default_ISR,                 /* 0xFFB6 MSCAN 0 wake-up */
    Default_ISR,                 /* 0xFFB8 Flash command */
    Default_ISR,                 /* 0xFFBA Flash error detect */
    ReservedISR,                 /* 0xFFBC Reserved */
    ReservedISR,                 /* 0xFFBE Reserved */
    Default_ISR,                 /* 0xFFC0 IIC */
    ReservedISR,                 /* 0xFFC2 Reserved */
    ReservedISR,                 /* 0xFFC4 Reserved */
    Default_ISR,                 /* 0xFFC6 CPMU PLL lock */
    Default_ISR,                 /* 0xFFC8 CPMU Oscillator Status */
    Default_ISR,                 /* 0xFFCA Port S */
    Default_ISR,                 /* 0xFFCC Port R */
    PORTAD_ISR,                 /* 0xFFCE Port AD */
    ReservedISR,                 /* 0xFFD0 Reserved */
    Default_ISR,                 /* 0xFFD2 ATD */
    ReservedISR,                 /* 0xFFD4 Reserved */
    Default_ISR,                 /* 0xFFD6 SCI */
    Default_ISR,                 /* 0xFFD8 SPI */
    Default_ISR,                 /* 0xFFDA TIM 0 Pulse accumulator input edge */
    Default_ISR,                 /* 0xFFDC TIM 0 Pulse accumulator A overflow */
    Default_ISR,                 /* 0xFFDE TIM 0 Timer overflow */
    Default_ISR,                 /* 0xFFE0 TIM 0 Timer channel 7 */
    Default_ISR,                 /* 0xFFE2 TIM 0 Timer channel 6 */
    Default_ISR,                 /* 0xFFE4 TIM 0 Timer channel 5 */
    Default_ISR,                 /* 0xFFE6 TIM 0 Timer channel 4 */
    Default_ISR,                 /* 0xFFE8 TIM 0 Timer channel 3 */
    Default_ISR,                 /* 0xFFEA TIM 0 Timer channel 2 */
    Default_ISR,                 /* 0xFFEC TIM 0 Timer channel 1 */
    Default_ISR,                 /* 0xFFEE TIM 0 Timer channel 0 */
    Default_ISR,                 /* 0xFFF0 Real Time Interrupt */
    Default_ISR,                 /* 0xFFF2 IRQ */
    Default_ISR,                 /* 0xFFF4 XIRQ */
    Default_ISR,                 /* 0xFFF6 SWI */
    Default_ISR,                 /* 0xFFF8 Unallocated instruction trap */
    Default_ISR,                 /* 0xFFFA COP watchdog reset */
    Default_ISR,                 /* 0xFFFC Clock monitor reset */
    _Startup,                    /* 0xFFFE Reset vector */
};
